<?php
/*
 * $Id$
 * 
 * License:  GNU General Public License
 *
 * Copyright (c) 2005 in3c.org
 * Portions Copyright (c) 2002 Y.MASUI
 *   http://masui.net/pukiwiki/ masui@masui.net
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 * 
 */


// Keyword⡼ɻ˻ȤɽξüΡ/פѡ
define("BLIKI_MORE","^#blikimore");

define("BLIKI_FOOTER","#blikifooter");

// ֤äɤץ󥯤ʸ
define("BLIKI_MORE_TEXT","&size(12){[[%s ³ɤ:%s]]};");

// åե¸ե
define('BLIKI_CACHEDIR','./cache/');

// ڡɤߤफ
define('BLIKI_DEFAULT_PAGE_NUM','10');

// åȤ
define('BLIKI_CACHE_MODE','0');

// ƥץ졼
define('BLIKI_TEMPLATE','<div>%s</div>');

// ƥȥ꡼ѥƥץ졼(wikiˡ) ִѰ => (ȥ, , ʸ, äȤ, blikifooter)
define('BLIKI_PAGE_WIKI_TEMPLATE',"
*%s
RIGHT: %s

%s

%s

%s
");

// ƥȥ꡼ѥƥץ졼(HTML) BLIKI_PAGE_WIKI_TEMPLATEƤ
define('BLIKI_PAGE_TEMPLATE',"<div class='blikiEntry'>%s</div>");


// ҥǥ쥯ȥΥɥȤ⥤󥯥롼ɤ뤫
define('BLIKI_CHILD', true);

// blikifooterʤڡ򥤥󥯥롼ɤ뤫
define('BLIKI_FOOTER_REQUIRED', true);

// includeץ饰Ÿ뤫?
define('BLIKI_PROCESS_INCLUDE_PLUGIN', true);


/**
 * 
 * 
 *     #bliki(pages,WikiName,child-page-control)
 * 
 *  
 *     ֥åץ饰
 *
 * 
 *      blogfooterץ饰ޤڡ򹹿includeޤ
 *      inlcludeڡblogmoreץ饰󤬤ȡʬޤǤ
 *      inlcludeޤ
 *      Olorin󤬺줿showcaseץ饰򸵤ˤƤޤ
 *      Olorin󤢤꤬Ȥޤ
 * 
 * 
 *      #bliki(15,hoge,1)   hoge/Υڡ򹹿15ɽ
 *      #bliki(15,hoge,0)   hoge/Υڡ򹹿15ɽ(ҥڡǤhoge/helloϴޤब¹ڡǤhoge/hello/worldϴޤޤʤ)
 *
 * @author Yuki SHIDA <shida@in3c.org>
 * @author Y.MASUI
 * @copyright Copyright &copy; in3c.org
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @version $Revision$
 * 
 */


function plugin_bliki_convert() {

    global $date_format;
    
    list($child, $cache_name, $recent_prefix, $page_num) 
        = bliki_process_args(func_get_args());

    $pages = bliki_get_pages($recent_prefix, $child, $cache_name);
    if (! $pages) {
        return "";
    }

    $entries = bliki_get_cache($cache_name);
    if (! is_null($entries) &&
        BLIKI_CACHE_MODE == 1) {
        return bliki_convert_html($entries, $page_num);
    }
    else {
        $entries = array();
    }

    $entry_num = 0;
    for ($cnt = 0; $cnt < sizeof($pages) && $entry_num < $page_num; ++$cnt) {
        $parse_result = bliki_parse_page($pages[$cnt]['page']);
        if (! $parse_result) {
            continue;
        }
        $entries[] = 
            array('page'  => $pages[$cnt]['page'], 
                  'entry' => sprintf(BLIKI_PAGE_WIKI_TEMPLATE,
                                     bliki_get_page_title($pages[$cnt]['page']),
                                     get_date($date_format, $pages[$cnt]['time']),
                                     $parse_result[0],
                                     $parse_result[1],
                                     $parse_result[2]));
        ++$entry_num;
    }

    bliki_write_cache($cache_name, $entries);
    return bliki_convert_html($entries, $page_num);
}


function plugin_bliki_action() {

    global $post, $vars;

    $cache = isset($vars['cache']) ? $vars['cache'] : null;
    
    // this delete tracker caches. 
    if( $cache == 'DELALL' ) {
        if (! bliki_delete_caches('(.*)(.blc)$')) {
            die_message( BLIKI_CACHEDIR . ' is not found or not readable.');
        }
            
        return array('result' => false,
                     'msg'    => 'bliki caches are cleared.',
                     'body'   => 'bliki caches are cleared.');
    }
}


function bliki_process_args($args) {

    global $vars, $defaultpage;

    $page_num      = BLIKI_DEFAULT_PAGE_NUM;
    $child         = BLIKI_CHILD;
    $cache_name    = $vars["page"];

    if (! is_null($args[0]) and
        is_numeric($args[0])) {
        $page_num = $args[0];
    }
    if (! is_null($args[1]) and
        $args[1] != '') {
        $cache_name = rtrim($args[1]);
    }
    if (! is_null($args[2]) and
        ($args[2] == '0') or 
        ($args[2] == '1')) {
        $child = ($args[2] == '1') ? true : false;
    }

    $recent_prefix = get_fullname(
                       strip_bracket($cache_name),
                                     $vars["page"]) . '/';

    if ($recent_prefix == $defaultpage . "/") {
        $recent_prefix = "";
    }

    return array($child, $cache_name, $recent_prefix, $page_num);
}


function bliki_get_pages($recent_prefix, $child, $cache_name) {

    if (!file_exists(CACHE_DIR . 'recent.dat')) {
        return false;
    }

    $lines = file(CACHE_DIR . 'recent.dat');
    $pages = array();

    foreach ($lines as $line) {
        list($time, $page) = explode("\t",rtrim($line));

        if (($recent_prefix != '') and 
            (strpos($page, $recent_prefix) !== 0)) {
            continue;
        }

        if ( (! $child) and 
             (strpos($page , '/' , strlen($recent_prefix)) !== false) ) {
            continue;
        }

        if (! check_readable($page, false, false)) {
            continue;
        }

        array_push($pages, array('time' => $time,
                                 'page' => $page));

        bliki_check_caches($cache_name, $time);
    }

    return $pages;
}


function bliki_check_caches($cache_name, $time) {

    $cache_file = BLIKI_CACHEDIR . encode($cache_name) .'.blc';

    if (file_exists($cache_file)){
        $cache_time = filemtime($cache_file) - LOCALZONE;
        if ($time > $cache_time) {
            unlink($cache_file);
        }
    }

    return true;
}


function bliki_get_cache($cache_name) {

    $cache_file = BLIKI_CACHEDIR . encode($cache_name) .'.blc';

    if (file_exists($cache_file)){
        return unserialize(join('', file($cache_file)));
    }
    else {
        return null;
    }
}

function bliki_write_cache($cache_name, $entries) {

    $cache_file = BLIKI_CACHEDIR . encode($cache_name) .'.blc';

    if (BLIKI_CACHE_MODE) {
        $fp = fopen($cache_file, 'w')
            or die_message('cannot write page file or diff file or other' . 
                           htmlspecialchars($cache_file) . 
                           '<br />maybe permission is not writable or filename is too long');
        flock($fp,LOCK_EX);
        fwrite($fp, serialize($entries));
        flock($fp,LOCK_UN);
        fclose($fp);
    }

    return true;
}
    

function bliki_delete_caches($del_pattern) {

    $dir = BLIKI_CACHEDIR;

    if(! $dp = @opendir($dir) ) {
            return false;
    }
    while($file = readdir($dp)) {
        if(preg_match("/$del_pattern/",$file)) {
            unlink($dir . $file);
        }
    }
    closedir($dp);
    return true;
}


function bliki_get_page_title($page) {

    return "[[" . htmlspecialchars($page) . ']] ' . get_pg_passage($page , false);
    
}

/**
 * BLIKI_FOOTER_REQUIREDtrueblikifooterĤʤϼ
 * 
 * 
 * @return  = ARRAY($body, $more, $footer),  = false
 */
function bliki_parse_page($page) {

    $lines = get_source($page);

    $body   = "";
    $more   = "";
    $footer = "";

    for($i =0;$i < sizeof($lines);++$i){
        $row = $lines[$i];
        //exclude #freeze & #norelated from the loop, avoid an infinite loop

        if(preg_match("/" . BLIKI_MORE . "/", $row)){
            $more = bliki_get_more($page);
            continue;
        }
        elseif(preg_match("/" . BLIKI_FOOTER . "/", $row)){
            $footer = $row;
            continue;
        }
        elseif(preg_match("/^(#freeze|#norelated|#bliki)$/m",$row)){
            continue;
        }
        elseif (preg_match('/^#include/', $row) &&
                BLIKI_PROCESS_INCLUDE_PLUGIN) {
            bliki_process_include_plugin($row, $lines, $i);
        }
        elseif (empty($more)) {
            $body .= $row;
        }
    }    

    if (empty($footer) && BLIKI_FOOTER_REQUIRED) {
        return false;
    }
    else {
        return array($body, 
                     $more,
                     $footer);
    }
}


function bliki_convert_html($entries, $page_num) {

    global $vars;

    for ($cnt = 0; $cnt < sizeof($entries) && $cnt < $page_num; ++$cnt) {
        $page_back    = $vars['page'];
        $vars['page'] = $entries[$cnt]['page'];
        $contents    .= sprintf(BLIKI_PAGE_TEMPLATE,
                                convert_html($entries[$cnt]['entry']));
        $vars['page'] = $page_back;
    }

    return sprintf(BLIKI_TEMPLATE, $contents);
}


function bliki_get_more($page) {

    global $script;

    return sprintf(BLIKI_MORE_TEXT,
                   htmlspecialchars($page),
                   $script . '?cmd=read&page=' . rawurlencode($page) . "#more" );
}

function bliki_process_include_plugin($row, &$lines, $i) {

    if (preg_match("/#include_interwiki/", $row)) {
        bliki_process_include_interwiki_plugin($row, $lines, $i);
    }

    return true;
}

function bliki_process_include_interwiki_plugin($row, &$lines, $i) {

    if (preg_match("/#include_interwiki\(([^,]*?),([^\)]*?)\)/", $row, $match) &&
        file_exists(PLUGIN_DIR . 'include_interwiki.inc.php')) {

        require_once(PLUGIN_DIR . 'include_interwiki.inc.php');
        
        $source = include_interwiki_get_source($match[1], $match[2]);

        $interwiki_lines = split("\n", $source);
        for ($x = 0;$x < sizeof($interwiki_lines);++$x) {
            $interwiki_lines[$x] .= "\n";
        }
        array_splice($lines, $i, 1, $interwiki_lines);
    }

    return true;
}

?>
